/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.pattern.placement;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.block.IMultiStateBlock;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.pattern.placement.IPatternPlacementType;
import mod.chiselsandbits.api.pattern.placement.PlacementResult;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.ColorUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.platforms.core.registries.AbstractCustomRegistryEntry;
import mod.chiselsandbits.registrars.ModPatternPlacementTypes;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;

public class ImposePatternPlacementType
extends AbstractCustomRegistryEntry
implements IPatternPlacementType {
    @Override
    @NotNull
    public class_2960 getIcon() {
        return new class_2960("chiselsandbits", "textures/icons/pattern_impose.png");
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.empty();
    }

    @Override
    public class_265 buildVoxelShapeForWireframe(IMultiStateSnapshot sourceSnapshot, class_1657 player, class_243 targetedPoint, class_2350 hitFace) {
        return ModPatternPlacementTypes.PLACEMENT.get().buildVoxelShapeForWireframe(sourceSnapshot, player, targetedPoint, hitFace);
    }

    @Override
    public PlacementResult performPlacement(IMultiStateSnapshot source, class_1750 context, boolean simulate) {
        boolean hasRequiredBits;
        boolean hasRequiredSpace;
        class_243 targetedPosition = context.method_8036().method_18276() ? context.method_17698() : class_243.method_24954((class_2382)context.method_8037().method_10081(context.method_8038().method_10153().method_10163()));
        IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().covering((class_1936)context.method_8045(), targetedPosition, targetedPosition.method_1031(0.9999, 0.9999, 0.9999));
        boolean isChiseledBlock = BlockPosStreamProvider.getForRange(areaMutator.getInWorldStartPoint(), areaMutator.getInWorldEndPoint()).map(pos -> context.method_8045().method_8320(pos)).allMatch(state -> state.method_26204() instanceof IMultiStateBlock);
        if (isChiseledBlock) {
            return PlacementResult.failure(ColorUtils.NOT_FITTING_PATTERN_PLACEMENT_COLOR, (class_2561)LocalStrings.PatternPlacementNotASolidBlock.getText());
        }
        boolean isSupported = BlockPosStreamProvider.getForRange(areaMutator.getInWorldStartPoint(), areaMutator.getInWorldEndPoint()).map(pos -> context.method_8045().method_8320(pos)).allMatch(IEligibilityManager.getInstance()::canBeChiseled);
        if (!isSupported) {
            return PlacementResult.failure(ColorUtils.NOT_FITTING_PATTERN_PLACEMENT_COLOR, (class_2561)LocalStrings.PatternPlacementNotASupportedBlock.getText());
        }
        Map<BlockInformation, Integer> extractedBitsCount = source.stream().filter(s -> !s.getBlockInformation().isAir()).map(IStateEntryInfo::getStartPoint).map(areaMutator::getInAreaTarget).filter(Optional::isPresent).map(Optional::get).filter(s -> !s.getBlockInformation().isAir()).collect(Collectors.toMap(IStateEntryInfo::getBlockInformation, s -> 1, Integer::sum));
        IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(context.method_8036());
        boolean bl = hasRequiredSpace = context.method_8036().method_7337() || extractedBitsCount.entrySet().stream().allMatch(e -> playerBitInventory.canInsert((BlockInformation)e.getKey(), (Integer)e.getValue()));
        if (!hasRequiredSpace) {
            return PlacementResult.failure(ColorUtils.MISSING_BITS_OR_SPACE_PATTERN_PLACEMENT_COLOR, (class_2561)LocalStrings.PatternPlacementNoBitSpace.getText());
        }
        boolean bl2 = hasRequiredBits = context.method_8036().method_7337() || source.getStatics().getStateCounts().entrySet().stream().filter(e -> !((BlockInformation)e.getKey()).isAir()).allMatch(e -> playerBitInventory.canExtract((BlockInformation)e.getKey(), (Integer)e.getValue()));
        if (!hasRequiredBits) {
            return PlacementResult.failure(ColorUtils.MISSING_BITS_OR_SPACE_PATTERN_PLACEMENT_COLOR, (class_2561)LocalStrings.PatternPlacementNotEnoughBits.getText());
        }
        if (simulate) {
            return PlacementResult.success();
        }
        try (IBatchMutation ignored = areaMutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(context.method_8036()));){
            source.stream().filter(s -> !s.getBlockInformation().isAir()).forEach(stateEntryInfo -> {
                try {
                    areaMutator.clearInAreaTarget(stateEntryInfo.getStartPoint());
                    areaMutator.setInAreaTarget(stateEntryInfo.getBlockInformation(), stateEntryInfo.getStartPoint());
                }
                catch (SpaceOccupiedException spaceOccupiedException) {
                    // empty catch block
                }
            });
        }
        if (!context.method_8036().method_7337()) {
            extractedBitsCount.forEach(playerBitInventory::insertOrDiscard);
            source.getStatics().getStateCounts().entrySet().stream().filter(e -> !((BlockInformation)e.getKey()).isAir()).forEach(e -> playerBitInventory.extract((BlockInformation)e.getKey(), (Integer)e.getValue()));
        }
        return PlacementResult.success();
    }

    @Override
    public class_243 getTargetedPosition(class_1799 heldStack, class_1657 playerEntity, class_3965 blockRayTraceResult) {
        if (playerEntity.method_18276()) {
            return blockRayTraceResult.method_17784();
        }
        return class_243.method_24954((class_2382)blockRayTraceResult.method_17777());
    }

    @Override
    public class_2561 getDisplayName() {
        return LocalStrings.PatternPlacementModeImposement.getText();
    }
}

